unit fService;
// PTLD/JIT  4-5-07

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ORCtrls, ExtCtrls, ORFn, ORNet;

type
  TfrmService = class(TForm)
    pnlService: TPanel;
    cbService: TORComboBox;
    lblService: TLabel;
    lblSpec: TLabel;
    btnSave: TButton;
    btnExit: TBitBtn;
    procedure btnExitClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure cbServiceChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmService: TfrmService;
  SpecData: TStrings;
  Edit: integer;

procedure GetService(SpecData: TStrings);

implementation

{$R *.dfm}

uses SCMMain, fParam;

procedure GetService(SpecData: TStrings);
begin
  frmService := TfrmService.Create(Application);
  try
    with frmService do
      begin
        lblSpec.Caption := SpecName;
        CallV('APTWL GET SERVICE', ['A']);
        cbService.Items := RPCBrokerV.Results;
        ShowModal;
      end;
  finally
    frmService.Release;
  end;
end;

procedure TfrmService.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmService.btnSaveClick(Sender: TObject);
var
  Success: string;
begin
  if cbService.Text = '' then
    begin
      MessageDlg('Please select a Service', mterror, [mbOK], 0);
      Exit;
    end;
  Success := sCallV('APTWL PUT SERVICE', [SpecIFN, cbService.ItemIEN]);
  if (piece(Success, '^', 1) = '1') and (piece(Success, '^', 2) = '1') then
    begin
      MessageDlg('Initial entries for ' + SpecName + ' have been created in ' + CRLF +
        'the Specialty Parameter and Case Manager files.', mtinformation, [mbOK], 0);
      if MessageDlg('Enter the other Specialty parameters for ' + SpecName + '?', mtinformation, [mbYes, mbNo], 0) = mrYes then
        begin
          Edit := 1;
          EditParam(SpecIFN);
        end;
      Close;
    end
  else MessageDlg('Service entry for ' + SpecName + ' was not successful.', mtwarning, [mbOK], 0);
end;

procedure TfrmService.cbServiceChange(Sender: TObject);
begin
  if cbService.Text = '' then Exit;
  CallV('APTWL GET SERVICE', [cbService.Text]);
  cbService.Items := RPCBrokerV.Results;
end;

end.
